/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries.holdersets;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;
import net.neoforged.neoforge.registries.holdersets.ICustomHolderSet;

public record AnyHolderSet<T>(HolderLookup.RegistryLookup<T> registryLookup) implements ICustomHolderSet<T>
{
    public static <T> MapCodec<? extends ICustomHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        return RegistryOps.retrieveRegistryLookup(registryKey).xmap(AnyHolderSet::new, AnyHolderSet::registryLookup);
    }

    @Override
    public HolderSetType type() {
        return (HolderSetType)NeoForgeMod.ANY_HOLDER_SET.value();
    }

    public Iterator<Holder<T>> iterator() {
        return this.stream().iterator();
    }

    public Stream<Holder<T>> stream() {
        return this.registryLookup.listElements().map(Function.identity());
    }

    public int size() {
        return (int)this.stream().count();
    }

    public Either<TagKey<T>, List<Holder<T>>> unwrap() {
        return Either.right(this.stream().toList());
    }

    public Optional<Holder<T>> getRandomElement(RandomSource random) {
        return Util.getRandomSafe(this.stream().toList(), (RandomSource)random);
    }

    public Holder<T> get(int i) {
        Holder<T> holder;
        List<Holder<T>> holders = this.stream().toList();
        Holder<T> holder2 = holder = i >= holders.size() ? null : holders.get(i);
        if (holder == null) {
            throw new NoSuchElementException("No element " + i + " in registry " + String.valueOf(this.registryLookup.key()));
        }
        return holder;
    }

    public boolean contains(Holder<T> holder) {
        return holder.unwrapKey().map(key -> this.registryLookup.listElementIds().anyMatch(key::equals)).orElse(false);
    }

    public boolean canSerializeIn(HolderOwner<T> holderOwner) {
        return true;
    }

    public Optional<TagKey<T>> unwrapKey() {
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "AnySet(" + String.valueOf(this.registryLookup.key()) + ")";
    }
}

