/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModifierManager
extends SimpleJsonResourceReloadListener<JsonElement> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = LogManager.getLogger();
    private Map<ResourceLocation, IGlobalLootModifier> registeredLootModifiers = ImmutableMap.of();
    private static final String folder = "loot_modifiers";

    public LootModifierManager() {
        super(ExtraCodecs.JSON, FileToIdConverter.json((String)folder));
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Map map = super.prepare(resourceManager, profilerFiller);
        ArrayList<ResourceLocation> finalLocations = new ArrayList<ResourceLocation>();
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"loot_modifiers/global_loot_modifiers.json");
        for (Resource resource : resourceManager.getResourceStack(resourceLocation)) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject jsonobject = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                    boolean replace = GsonHelper.getAsBoolean((JsonObject)jsonobject, (String)"replace", (boolean)false);
                    if (replace) {
                        finalLocations.clear();
                    }
                    JsonArray entries = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"entries");
                    for (int i = 0; i < entries.size(); ++i) {
                        ResourceLocation loc = ResourceLocation.parse((String)GsonHelper.convertToString((JsonElement)entries.get(i), (String)("entries[" + i + "]")));
                        finalLocations.remove(loc);
                        finalLocations.add(loc);
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException | RuntimeException ioexception) {
                LOGGER.error("Couldn't read global loot modifier list {} in data pack {}", (Object)resourceLocation, (Object)resource.sourcePackId(), (Object)ioexception);
            }
        }
        HashMap<ResourceLocation, JsonElement> finalMap = new HashMap<ResourceLocation, JsonElement>();
        for (ResourceLocation location : finalLocations) {
            finalMap.put(location, (JsonElement)map.get(location));
        }
        return finalMap;
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceList, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ConditionalOps ops = this.makeConditionalOps();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceList.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonElement json = entry.getValue();
            IGlobalLootModifier.CONDITIONAL_CODEC.parse((DynamicOps)ops, (Object)json).resultOrPartial(errorMsg -> LOGGER.warn("Could not decode GlobalLootModifier with json id {} - error: {}", (Object)location, errorMsg)).flatMap(Function.identity()).ifPresent(carrier -> builder.put((Object)location, (Object)((IGlobalLootModifier)carrier.carrier())));
        }
        this.registeredLootModifiers = builder.build();
    }

    public Collection<IGlobalLootModifier> getAllLootMods() {
        return this.registeredLootModifiers.values();
    }
}

