/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ComposterWrapper
extends SnapshotJournal<Float> {
    private static final Map<WrapperLocation, ComposterWrapper> wrappers = new MapMaker().concurrencyLevel(1).weakKeys().weakValues().makeMap();
    private static final ItemResource BONE_MEAL = ItemResource.of((ItemLike)Items.BONE_MEAL);
    private static final Float DO_NOTHING = Float.valueOf(0.0f);
    private static final Float EXTRACT_BONEMEAL = Float.valueOf(-1.0f);
    private final WrapperLocation location;
    private Float increaseProbability = DO_NOTHING;
    private final ResourceHandler<ItemResource> topHandler = new Top();
    private final ResourceHandler<ItemResource> bottomHandler = new Bottom();

    @Nullable
    public static ResourceHandler<ItemResource> get(Level level, BlockPos pos, @Nullable Direction direction) {
        if (direction == null || !direction.getAxis().isVertical()) {
            return null;
        }
        WrapperLocation location = new WrapperLocation(level, pos.immutable());
        ComposterWrapper wrapper = wrappers.computeIfAbsent(location, ComposterWrapper::new);
        return direction == Direction.UP ? wrapper.topHandler : wrapper.bottomHandler;
    }

    private ComposterWrapper(WrapperLocation location) {
        this.location = location;
    }

    @Override
    protected Float createSnapshot() {
        return this.increaseProbability;
    }

    @Override
    protected void revertToSnapshot(Float snapshot) {
        this.increaseProbability = snapshot;
    }

    @Override
    protected void onRootCommit(Float originalState) {
        if (this.increaseProbability.equals(EXTRACT_BONEMEAL)) {
            BlockState newState = (BlockState)this.location.getBlockState().setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(0));
            this.location.level.setBlockAndUpdate(this.location.pos, newState);
            this.location.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.location.pos, GameEvent.Context.of(null, (BlockState)newState));
        } else {
            boolean increaseSuccessful;
            BlockState state = this.location.getBlockState();
            boolean bl = increaseSuccessful = (Integer)state.getValue((Property)ComposterBlock.LEVEL) == 0 || this.location.level.getRandom().nextDouble() < (double)this.increaseProbability.floatValue();
            if (increaseSuccessful) {
                int newLevel = (Integer)state.getValue((Property)ComposterBlock.LEVEL) + 1;
                BlockState newState = (BlockState)state.setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(newLevel));
                this.location.level.setBlockAndUpdate(this.location.pos, newState);
                this.location.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.location.pos, GameEvent.Context.of(null, (BlockState)newState));
                if (newLevel == 7) {
                    this.location.level.scheduleTick(this.location.pos, state.getBlock(), 20);
                }
            }
            this.location.level.levelEvent(1500, this.location.pos, increaseSuccessful ? 1 : 0);
        }
        this.increaseProbability = DO_NOTHING;
    }

    private boolean hasBoneMeal() {
        return this.increaseProbability.equals(DO_NOTHING) && (Integer)this.location.getBlockState().getValue((Property)ComposterBlock.LEVEL) == 8;
    }

    private static float getComposterValue(ItemResource resource) {
        return ComposterBlock.getValue((ItemStack)resource.toStack());
    }

    private record WrapperLocation(Level level, BlockPos pos) {
        public BlockState getBlockState() {
            return this.level.getBlockState(this.pos);
        }
    }

    private class Top
    implements ResourceHandler<ItemResource> {
        private Top() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
            Objects.checkIndex(index, this.size());
            TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
            if (amount < 1) {
                return 0;
            }
            if (!ComposterWrapper.this.increaseProbability.equals(DO_NOTHING)) {
                return 0;
            }
            if ((Integer)ComposterWrapper.this.location.getBlockState().getValue((Property)ComposterBlock.LEVEL) >= 7) {
                return 0;
            }
            float insertedIncreaseProbability = ComposterWrapper.getComposterValue(resource);
            if (insertedIncreaseProbability <= 0.0f) {
                return 0;
            }
            ComposterWrapper.this.updateSnapshots(transaction);
            ComposterWrapper.this.increaseProbability = Float.valueOf(insertedIncreaseProbability);
            return 1;
        }

        @Override
        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            return 0;
        }

        @Override
        public ItemResource getResource(int index) {
            return ItemResource.EMPTY;
        }

        @Override
        public long getAmountAsLong(int index) {
            return 0L;
        }

        @Override
        public long getCapacityAsLong(int index, ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return resource.isEmpty() || ComposterWrapper.getComposterValue(resource) > 0.0f ? 1L : 0L;
        }

        @Override
        public boolean isValid(int index, ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return ComposterWrapper.getComposterValue(resource) > 0.0f;
        }

        public String toString() {
            return "ComposterWrapper[" + String.valueOf(ComposterWrapper.this.location) + "/top]";
        }
    }

    private class Bottom
    implements ResourceHandler<ItemResource> {
        private Bottom() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
            return 0;
        }

        @Override
        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            Objects.checkIndex(index, this.size());
            TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
            if (amount < 1) {
                return 0;
            }
            if (!BONE_MEAL.equals(resource)) {
                return 0;
            }
            if (!ComposterWrapper.this.hasBoneMeal()) {
                return 0;
            }
            ComposterWrapper.this.updateSnapshots(transaction);
            ComposterWrapper.this.increaseProbability = EXTRACT_BONEMEAL;
            return 1;
        }

        @Override
        public ItemResource getResource(int index) {
            Objects.checkIndex(index, this.size());
            return ComposterWrapper.this.hasBoneMeal() ? BONE_MEAL : ItemResource.EMPTY;
        }

        @Override
        public long getAmountAsLong(int index) {
            Objects.checkIndex(index, this.size());
            return ComposterWrapper.this.hasBoneMeal() ? 1L : 0L;
        }

        @Override
        public long getCapacityAsLong(int index, ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return resource.isEmpty() || BONE_MEAL.equals(resource) ? 1L : 0L;
        }

        @Override
        public boolean isValid(int index, ItemResource resource) {
            Objects.checkIndex(index, this.size());
            return BONE_MEAL.equals(resource);
        }

        public String toString() {
            return "ComposterWrapper[" + String.valueOf(ComposterWrapper.this.location) + "/bottom]";
        }
    }
}

