/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.transfer.ItemAccessResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;

public class ItemAccessItemHandler
extends ItemAccessResourceHandler<ItemResource> {
    protected final Item validItem;
    protected final DataComponentType<ItemContainerContents> component;

    public ItemAccessItemHandler(ItemAccess itemAccess, DataComponentType<ItemContainerContents> component, int size) {
        super(itemAccess, size);
        this.validItem = itemAccess.getResource().getItem();
        this.component = component;
        Preconditions.checkArgument((size <= 256 ? 1 : 0) != 0, (Object)"The max size of ItemContainerContents is 256 slots.");
    }

    protected ItemContainerContents getContents(ItemResource accessResource) {
        return (ItemContainerContents)accessResource.getOrDefault(this.component, ItemContainerContents.EMPTY);
    }

    protected ItemStack getStackFromContents(ItemContainerContents contents, int slot) {
        return slot < contents.getSlots() ? contents.getStackInSlot(slot) : ItemStack.EMPTY;
    }

    @Override
    protected ItemResource getResourceFrom(ItemResource accessResource, int index) {
        if (accessResource.is(this.validItem)) {
            return ItemResource.of(this.getStackFromContents(this.getContents(accessResource), index));
        }
        return ItemResource.EMPTY;
    }

    @Override
    protected int getAmountFrom(ItemResource accessResource, int index) {
        if (accessResource.is(this.validItem)) {
            return this.getStackFromContents(this.getContents(accessResource), index).getCount();
        }
        return 0;
    }

    @Override
    protected ItemResource update(ItemResource accessResource, int index, ItemResource newResource, int newAmount) {
        ItemContainerContents contents = this.getContents(accessResource);
        NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), this.size), (Object)ItemStack.EMPTY);
        contents.copyInto(list);
        list.set(index, (Object)newResource.toStack(newAmount));
        return accessResource.with((DataComponentType)this.component, (Object)ItemContainerContents.fromItems((List)list));
    }

    @Override
    public boolean isValid(int index, ItemResource resource) {
        return this.itemAccess.getResource().is(this.validItem);
    }

    @Override
    protected int getCapacity(int index, ItemResource resource) {
        return resource.isEmpty() ? 99 : Math.min(resource.getMaxStackSize(), 99);
    }
}

