/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ColorResolver;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public abstract class RegisterColorHandlersEvent
extends Event
implements IModBusEvent {
    @ApiStatus.Internal
    protected RegisterColorHandlersEvent() {
    }

    public static class ItemTintSources
    extends RegisterColorHandlersEvent {
        private final ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends ItemTintSource>> idMapper;

        @ApiStatus.Internal
        public ItemTintSources(ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends ItemTintSource>> idMapper) {
            this.idMapper = idMapper;
        }

        public void register(ResourceLocation location, MapCodec<? extends ItemTintSource> source) {
            this.idMapper.put((Object)location, source);
        }
    }

    public static class ColorResolvers
    extends RegisterColorHandlersEvent {
        private final ImmutableList.Builder<ColorResolver> builder;

        @ApiStatus.Internal
        public ColorResolvers(ImmutableList.Builder<ColorResolver> builder) {
            this.builder = builder;
        }

        public void register(ColorResolver resolver) {
            this.builder.add((Object)resolver);
        }
    }

    public static class Block
    extends RegisterColorHandlersEvent {
        private final BlockColors blockColors;

        @ApiStatus.Internal
        public Block(BlockColors blockColors) {
            this.blockColors = blockColors;
        }

        public BlockColors getBlockColors() {
            return this.blockColors;
        }

        public void register(BlockColor blockColor, net.minecraft.world.level.block.Block ... blocks) {
            this.blockColors.register(blockColor, blocks);
        }
    }
}

