/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

@Mod(value="neoforge")
@ApiStatus.Internal
public class OnlyInWarningsHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean HIDE_WARNING_SCREEN = Boolean.getBoolean("neoforge.warnings.onlyin.hide");

    public OnlyInWarningsHandler(ModContainer container) {
        if (!FMLEnvironment.isProduction()) {
            ModList.get().forEachModFile(file -> {
                if (file.getModInfos().stream().anyMatch(info -> info.getModId().equals("minecraft"))) {
                    return;
                }
                Type anType = Type.getType(OnlyIn.class);
                List<ModFileScanData.AnnotationData> onlyInUsages = file.getScanResult().getAnnotations().stream().filter(ad -> ad.annotationType().equals((Object)anType)).toList();
                if (!onlyInUsages.isEmpty()) {
                    if (!HIDE_WARNING_SCREEN) {
                        ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.warning((String)"loadwarning.neoforge.onlyin", (Object[])new Object[]{((IModInfo)file.getModInfos().getFirst()).getModId()}).withAffectedModFile(file));
                    }
                    LOGGER.error("The mod {} uses the @OnlyIn annotation; the runtime member-stripping behaviour of this annotation is no longer present, which may lead to issues if that behaviour was relied upon", (Object)((IModInfo)file.getModInfos().getFirst()).getModId());
                    for (ModFileScanData.AnnotationData annData : onlyInUsages) {
                        switch (annData.targetType()) {
                            case TYPE: {
                                LOGGER.error("@OnlyIn used on class {}", (Object)annData.clazz().getClassName());
                                break;
                            }
                            case FIELD: {
                                LOGGER.error("@OnlyIn used on field {}.{}", (Object)annData.clazz().getClassName(), (Object)annData.memberName());
                                break;
                            }
                            case METHOD: {
                                LOGGER.error("@OnlyIn used on method {}.{}", (Object)annData.clazz().getClassName(), (Object)annData.memberName());
                                break;
                            }
                            case CONSTRUCTOR: {
                                LOGGER.error("@OnlyIn used on constructor for {}", (Object)annData.clazz().getClassName());
                                break;
                            }
                            case ANNOTATION_TYPE: {
                                LOGGER.error("@OnlyIn used on annotation {}", (Object)annData.clazz().getClassName());
                                break;
                            }
                            case PACKAGE: {
                                LOGGER.error("@OnlyIn used on package {}", (Object)annData.clazz().getClassName());
                            }
                        }
                    }
                }
            });
        }
    }
}

