/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.fluid;

import java.util.Objects;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ItemAccessResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;

public final class BucketResourceHandler
extends ItemAccessResourceHandler<FluidResource> {
    public BucketResourceHandler(ItemAccess itemAccess) {
        super(itemAccess, 1);
    }

    @Override
    protected FluidResource getResourceFrom(ItemResource accessResource, int index) {
        Item item = accessResource.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            return FluidResource.of(bucketItem.content);
        }
        if (accessResource.is(Items.MILK_BUCKET) && NeoForgeMod.MILK.isBound()) {
            return FluidResource.of(NeoForgeMod.MILK.get());
        }
        return FluidResource.EMPTY;
    }

    @Override
    protected int getAmountFrom(ItemResource accessResource, int index) {
        FluidResource resource = this.getResourceFrom(accessResource, index);
        return resource.isEmpty() ? 0 : 1000;
    }

    @Override
    protected ItemResource update(ItemResource accessResource, int index, FluidResource newResource, int newAmount) {
        if (newAmount == 0) {
            return ItemResource.of((ItemLike)Items.BUCKET);
        }
        if (newAmount != 1000) {
            return ItemResource.EMPTY;
        }
        FluidStack newStack = newResource.toStack(newAmount);
        return ItemResource.of(newStack.getFluidType().getBucket(newStack));
    }

    @Override
    protected int getCapacity(int index, FluidResource resource) {
        Objects.checkIndex(index, this.size());
        return 1000;
    }
}

