/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.generators.template;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.model.generators.template.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.template.ElementBuilder;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplate;
import net.neoforged.neoforge.client.model.generators.template.RootTransformsBuilder;
import net.neoforged.neoforge.client.model.generators.template.TransformVecBuilder;
import org.jetbrains.annotations.Nullable;

public class ExtendedModelTemplateBuilder {
    Optional<ResourceLocation> parent = Optional.empty();
    Optional<String> suffix = Optional.empty();
    final Set<TextureSlot> requiredSlots = new HashSet<TextureSlot>();
    final Map<ItemDisplayContext, TransformVecBuilder> transforms = new LinkedHashMap<ItemDisplayContext, TransformVecBuilder>();
    final List<ElementBuilder> elements = new ArrayList<ElementBuilder>();
    @Nullable
    CustomLoaderBuilder customLoader = null;
    final RootTransformsBuilder rootTransforms = new RootTransformsBuilder();
    @Nullable
    ResourceLocation renderType = null;
    @Nullable
    Boolean ambientOcclusion = null;
    @Nullable
    UnbakedModel.GuiLight guiLight = null;

    public static ExtendedModelTemplateBuilder of(ModelTemplate template) {
        ExtendedModelTemplateBuilder builder = new ExtendedModelTemplateBuilder();
        builder.parent = template.model;
        builder.suffix = template.suffix;
        builder.requiredSlots.addAll(template.requiredSlots);
        if (template instanceof ExtendedModelTemplate) {
            ExtendedModelTemplate ext = (ExtendedModelTemplate)template;
            ext.transforms.forEach((ctx, vecBuilder) -> builder.transforms.put((ItemDisplayContext)ctx, vecBuilder.copy()));
            ext.elements.forEach(elem -> builder.elements.add(elem.copy()));
            builder.customLoader = ext.customLoader != null ? ext.customLoader.copy() : null;
            builder.rootTransforms.copyFrom(ext.rootTransforms);
            builder.renderType = ext.renderType;
            builder.ambientOcclusion = ext.ambientOcclusion;
            builder.guiLight = ext.guiLight;
        }
        return builder;
    }

    public static ExtendedModelTemplateBuilder builder() {
        return new ExtendedModelTemplateBuilder();
    }

    public ExtendedModelTemplateBuilder parent(ResourceLocation parent) {
        this.parent = Optional.of(parent);
        return this;
    }

    public ExtendedModelTemplateBuilder suffix(String suffix) {
        this.suffix = Optional.of(suffix);
        return this;
    }

    public ExtendedModelTemplateBuilder requiredTextureSlot(TextureSlot slot) {
        this.requiredSlots.add(slot);
        return this;
    }

    public ExtendedModelTemplateBuilder renderType(String renderType) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        return this.renderType(ResourceLocation.parse((String)renderType));
    }

    public ExtendedModelTemplateBuilder renderType(ResourceLocation renderType) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        this.renderType = renderType;
        return this;
    }

    public ExtendedModelTemplateBuilder transform(ItemDisplayContext type, Consumer<TransformVecBuilder> action) {
        Preconditions.checkNotNull((Object)type, (Object)"Perspective cannot be null");
        TransformVecBuilder builder = this.transforms.computeIfAbsent(type, TransformVecBuilder::new);
        action.accept(builder);
        return this;
    }

    public ExtendedModelTemplateBuilder ambientOcclusion(boolean ambientOcclusion) {
        this.ambientOcclusion = ambientOcclusion;
        return this;
    }

    public ExtendedModelTemplateBuilder guiLight(UnbakedModel.GuiLight light) {
        this.guiLight = light;
        return this;
    }

    public ExtendedModelTemplateBuilder element(Consumer<ElementBuilder> action) {
        Preconditions.checkState((this.customLoader == null || this.customLoader.allowInlineElements ? 1 : 0) != 0, (String)"Custom model loader %s does not support inline elements", this.customLoader != null ? this.customLoader.loaderId : null);
        ElementBuilder ret = new ElementBuilder();
        action.accept(ret);
        this.elements.add(ret);
        return this;
    }

    public ExtendedModelTemplateBuilder element(int index, Consumer<ElementBuilder> action) {
        Preconditions.checkState((this.customLoader == null || this.customLoader.allowInlineElements ? 1 : 0) != 0, (String)"Custom model loader %s does not support inline elements", this.customLoader != null ? this.customLoader.loaderId : null);
        Preconditions.checkElementIndex((int)index, (int)this.elements.size(), (String)"Element index");
        action.accept(this.elements.get(index));
        return this;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public <L extends CustomLoaderBuilder> ExtendedModelTemplateBuilder customLoader(Supplier<L> customLoaderFactory, Consumer<L> action) {
        Preconditions.checkNotNull(customLoaderFactory, (Object)"customLoaderFactory must not be null");
        CustomLoaderBuilder customLoader = (CustomLoaderBuilder)customLoaderFactory.get();
        Preconditions.checkState((customLoader.allowInlineElements || this.elements.isEmpty() ? 1 : 0) != 0, (String)"Custom model loader %s does not support inline elements", (Object)customLoader.loaderId);
        this.customLoader = customLoader;
        action.accept(customLoader);
        return this;
    }

    public ExtendedModelTemplateBuilder rootTransforms(Consumer<RootTransformsBuilder> action) {
        action.accept(this.rootTransforms);
        return this;
    }

    public ExtendedModelTemplate build() {
        return new ExtendedModelTemplate(this);
    }
}

