/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class DataComponentUtil {
    public static <T extends DataComponentHolder> Tag wrapEncodingExceptions(T componentHolder, Codec<T> codec, HolderLookup.Provider provider, Tag tag) {
        try {
            return (Tag)codec.encode(componentHolder, (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow();
        }
        catch (Exception exception) {
            DataComponentUtil.logDataComponentSaveError(componentHolder, exception, tag);
            throw exception;
        }
    }

    public static <T extends DataComponentHolder> Tag wrapEncodingExceptions(T componentHolder, Codec<T> codec, HolderLookup.Provider provider) {
        try {
            return (Tag)codec.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), componentHolder).getOrThrow();
        }
        catch (Exception exception) {
            DataComponentUtil.logDataComponentSaveError(componentHolder, exception, null);
            throw exception;
        }
    }

    public static void logDataComponentSaveError(DataComponentHolder componentHolder, Exception original, @Nullable Tag tag) {
        StringBuilder cause = new StringBuilder("Error saving [" + String.valueOf(componentHolder) + "]. Original cause: " + String.valueOf(original));
        cause.append("\nWith components:\n{");
        componentHolder.getComponents().forEach(component -> cause.append("\n\t").append(component));
        cause.append("\n}");
        if (tag != null) {
            cause.append("\nWith tag: ").append(tag);
        }
        Util.logAndPauseIfInIde((String)cause.toString());
    }
}

