/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.items;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.ContainerOrHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VanillaInventoryCodeHooks {
    public static boolean extractHook(Hopper dest, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractItem = handler.extractItem(i, 1, true);
            if (extractItem.isEmpty()) continue;
            for (int j = 0; j < dest.getContainerSize(); ++j) {
                ItemStack destStack = dest.getItem(j);
                if (!dest.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= dest.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)extractItem, (ItemStack)destStack))) continue;
                extractItem = handler.extractItem(i, 1, false);
                if (destStack.isEmpty()) {
                    dest.setItem(j, extractItem);
                } else {
                    destStack.grow(1);
                    dest.setItem(j, destStack);
                }
                dest.setChanged();
                return true;
            }
        }
        return false;
    }

    public static boolean insertHook(HopperBlockEntity hopper, IItemHandler itemHandler) {
        if (VanillaInventoryCodeHooks.isFull(itemHandler)) {
            return false;
        }
        for (int i = 0; i < hopper.getContainerSize(); ++i) {
            if (hopper.getItem(i).isEmpty()) continue;
            ItemStack originalSlotContents = hopper.getItem(i).copy();
            ItemStack insertStack = hopper.removeItem(i, 1);
            ItemStack remainder = ItemHandlerHelper.insertItem(itemHandler, insertStack, false);
            if (remainder.isEmpty()) {
                return true;
            }
            hopper.setItem(i, originalSlotContents);
        }
        return false;
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    public static ContainerOrHandler getEntityContainerOrHandler(Level level, double x, double y, double z, @Nullable Direction side) {
        List list = level.getEntities((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), entity -> {
            if (!entity.isAlive()) {
                return false;
            }
            return entity instanceof Container || entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side) != null;
        });
        if (!list.isEmpty()) {
            Entity entity2 = (Entity)list.get(level.random.nextInt(list.size()));
            if (entity2 instanceof Container) {
                Container container = (Container)entity2;
                return new ContainerOrHandler(container, null);
            }
            IItemHandler entityCap = (IItemHandler)entity2.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side);
            if (entityCap != null) {
                return new ContainerOrHandler(null, entityCap);
            }
        }
        return ContainerOrHandler.EMPTY;
    }
}

