/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.event.RegisterNamedRenderTypesEvent;
import org.jetbrains.annotations.ApiStatus;

public final class NamedRenderTypeManager {
    private static ImmutableMap<ResourceLocation, RenderTypeGroup> RENDER_TYPES;

    public static RenderTypeGroup get(ResourceLocation name) {
        return (RenderTypeGroup)RENDER_TYPES.getOrDefault((Object)name, (Object)RenderTypeGroup.EMPTY);
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<ResourceLocation, RenderTypeGroup> renderTypes = new HashMap<ResourceLocation, RenderTypeGroup>();
        NamedRenderTypeManager.preRegisterVanillaRenderTypes(renderTypes);
        RegisterNamedRenderTypesEvent event = new RegisterNamedRenderTypesEvent(renderTypes);
        ModLoader.postEventWrapContainerInModOrder((Event)event);
        RENDER_TYPES = ImmutableMap.copyOf(renderTypes);
    }

    private static void preRegisterVanillaRenderTypes(Map<ResourceLocation, RenderTypeGroup> blockRenderTypes) {
        blockRenderTypes.put(ResourceLocation.withDefaultNamespace((String)"solid"), new RenderTypeGroup(ChunkSectionLayer.SOLID, NeoForgeRenderTypes.ITEM_LAYERED_SOLID.get()));
        blockRenderTypes.put(ResourceLocation.withDefaultNamespace((String)"cutout"), new RenderTypeGroup(ChunkSectionLayer.CUTOUT, NeoForgeRenderTypes.ITEM_LAYERED_CUTOUT.get()));
        blockRenderTypes.put(ResourceLocation.withDefaultNamespace((String)"cutout_mipped"), new RenderTypeGroup(ChunkSectionLayer.CUTOUT_MIPPED, NeoForgeRenderTypes.ITEM_LAYERED_CUTOUT.get()));
        blockRenderTypes.put(ResourceLocation.withDefaultNamespace((String)"cutout_mipped_all"), new RenderTypeGroup(ChunkSectionLayer.CUTOUT_MIPPED, NeoForgeRenderTypes.ITEM_LAYERED_CUTOUT_MIPPED.get()));
        blockRenderTypes.put(ResourceLocation.withDefaultNamespace((String)"translucent"), new RenderTypeGroup(ChunkSectionLayer.TRANSLUCENT, NeoForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get()));
        blockRenderTypes.put(ResourceLocation.withDefaultNamespace((String)"tripwire"), new RenderTypeGroup(ChunkSectionLayer.TRIPWIRE, NeoForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get()));
    }

    private NamedRenderTypeManager() {
    }
}

