/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.blaze3d.validation;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.function.Supplier;
import net.neoforged.neoforge.client.blaze3d.validation.GpuDeviceUsageValidator;
import net.neoforged.neoforge.client.blaze3d.validation.ValidationGpuTextureView;
import org.jetbrains.annotations.Nullable;

public class ValidationRenderPass
implements RenderPass {
    private final RenderPass realRenderPass;
    private final GpuDeviceUsageValidator validator;

    protected ValidationRenderPass(RenderPass realRenderPass, GpuDeviceUsageValidator validator) {
        this.realRenderPass = realRenderPass;
        this.validator = validator;
    }

    public void pushDebugGroup(Supplier<String> label) {
        this.realRenderPass.pushDebugGroup(label);
    }

    public void popDebugGroup() {
        this.realRenderPass.popDebugGroup();
    }

    public void setPipeline(RenderPipeline pipeline) {
        this.validator.validatePipeline(pipeline);
        this.realRenderPass.setPipeline(pipeline);
    }

    public void bindSampler(String name, @Nullable GpuTextureView textureView) {
        if (textureView instanceof ValidationGpuTextureView) {
            ValidationGpuTextureView validationTextureView = (ValidationGpuTextureView)textureView;
            textureView = validationTextureView.getRealTextureView();
        }
        this.realRenderPass.bindSampler(name, textureView);
    }

    public void setUniform(String name, GpuBuffer buffer) {
        this.realRenderPass.setUniform(name, buffer);
    }

    public void setUniform(String name, GpuBufferSlice bufferSlice) {
        this.realRenderPass.setUniform(name, bufferSlice);
    }

    public void setViewport(int x, int y, int width, int height) {
        this.realRenderPass.setViewport(x, y, width, height);
    }

    public void enableScissor(int x, int y, int width, int height) {
        this.realRenderPass.enableScissor(x, y, width, height);
    }

    public void disableScissor() {
        this.realRenderPass.disableScissor();
    }

    public void setVertexBuffer(int index, GpuBuffer vertexBuffer) {
        this.realRenderPass.setVertexBuffer(index, vertexBuffer);
    }

    public void setIndexBuffer(GpuBuffer indexBuffer, VertexFormat.IndexType indexType) {
        this.realRenderPass.setIndexBuffer(indexBuffer, indexType);
    }

    public void drawIndexed(int vertexOffset, int firstIndex, int indexCount, int instanceCount) {
        this.realRenderPass.drawIndexed(vertexOffset, firstIndex, indexCount, instanceCount);
    }

    public <T> void drawMultipleIndexed(Collection<RenderPass.Draw<T>> draws, @Nullable GpuBuffer indexBuffer, @Nullable VertexFormat.IndexType indexType, Collection<String> dynamicUniforms, T userData) {
        this.realRenderPass.drawMultipleIndexed(draws, indexBuffer, indexType, dynamicUniforms, userData);
    }

    public void draw(int firstVertex, int vertexCount) {
        this.realRenderPass.draw(firstVertex, vertexCount);
    }

    public void close() {
        this.realRenderPass.close();
    }
}

