/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.RenderTypeGroup;
import org.jetbrains.annotations.ApiStatus;

public class RegisterNamedRenderTypesEvent
extends Event
implements IModBusEvent {
    private final Map<ResourceLocation, RenderTypeGroup> renderTypes;

    @ApiStatus.Internal
    public RegisterNamedRenderTypesEvent(Map<ResourceLocation, RenderTypeGroup> renderTypes) {
        this.renderTypes = renderTypes;
    }

    public void register(ResourceLocation key, ChunkSectionLayer chunkLayer, RenderType entityRenderType) {
        Preconditions.checkArgument((!this.renderTypes.containsKey(key) ? 1 : 0) != 0, (Object)("Render type already registered: " + String.valueOf(key)));
        Preconditions.checkArgument((entityRenderType.format() == DefaultVertexFormat.NEW_ENTITY ? 1 : 0) != 0, (Object)"The entity render type must use the NEW_ENTITY vertex format.");
        this.renderTypes.put(key, new RenderTypeGroup(chunkLayer, entityRenderType));
    }
}

