/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.include.com.google.common.base.Preconditions;

@ApiStatus.Internal
public class VanillaClassToKey {
    public static ResourceLocation convert(Class<?> cls) {
        Preconditions.checkArgument((boolean)cls.getPackageName().startsWith("net.minecraft"), (Object)("Automatic name conversion can only be applied to net.minecraft classes. Provided: " + cls.getName()));
        Preconditions.checkArgument((!cls.getSimpleName().isEmpty() ? 1 : 0) != 0, (Object)("Automatic name conversion can only happen for identifiable classes (per Class#getSimpleName()). Provided: " + cls.getName()));
        StringBuilder sb = new StringBuilder();
        cls.getSimpleName().chars().mapMulti((value, consumer) -> {
            if (Character.isUpperCase((char)value)) {
                consumer.accept(95);
                consumer.accept(Character.toLowerCase((char)value));
            } else {
                consumer.accept(value);
            }
        }).forEach(i -> sb.append((char)i));
        return ResourceLocation.withDefaultNamespace((String)sb.substring(1));
    }
}

