/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.merge;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MergeResult<T> {
    private final T result;
    private final List<T> mappingsToMap;

    public MergeResult(T result) {
        this.result = result;
        this.mappingsToMap = Collections.emptyList();
    }

    public MergeResult(T result, T mappingToMerge) {
        this.result = Objects.requireNonNull(result, "Merge action result must not be null");
        this.mappingsToMap = Collections.singletonList(Objects.requireNonNull(mappingToMerge, "Merge action mapping must not be null"));
    }

    public MergeResult(T result, List<T> mappingsToMap) {
        this.result = Objects.requireNonNull(result, "Merge action result must not be null");
        this.mappingsToMap = Objects.requireNonNull(mappingsToMap, "Merge action mappings must not be null");
    }

    public T getResult() {
        return this.result;
    }

    public List<T> getMappingsToMap() {
        return this.mappingsToMap;
    }

    public String toString() {
        return "MergeResult{result=" + this.result + ", mappingsToMap=" + this.mappingsToMap + '}';
    }
}

