/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.model;

import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.merge.MappingSetMerger;
import org.cadixdev.lorenz.model.ClassMapping;

public interface TopLevelClassMapping
extends ClassMapping<TopLevelClassMapping, MappingSet> {
    @Override
    default public String getSimpleObfuscatedName() {
        String name = this.getObfuscatedName();
        int classIndex = name.lastIndexOf(47);
        return classIndex >= 0 ? name.substring(classIndex + 1) : name;
    }

    @Override
    default public String getSimpleDeobfuscatedName() {
        String name = this.getDeobfuscatedName();
        int classIndex = name.lastIndexOf(47);
        return classIndex >= 0 ? name.substring(classIndex + 1) : name;
    }

    @Override
    default public String getFullObfuscatedName() {
        return this.getObfuscatedName();
    }

    @Override
    default public String getFullDeobfuscatedName() {
        return this.getDeobfuscatedName();
    }

    @Override
    default public String getObfuscatedPackage() {
        String name = this.getObfuscatedName();
        int classIndex = name.lastIndexOf(47);
        return classIndex >= 0 ? name.substring(0, classIndex) : "";
    }

    @Override
    default public String getDeobfuscatedPackage() {
        String name = this.getDeobfuscatedName();
        int classIndex = name.lastIndexOf(47);
        return classIndex >= 0 ? name.substring(0, classIndex) : "";
    }

    @Override
    default public TopLevelClassMapping reverse(MappingSet parent) {
        TopLevelClassMapping mapping = parent.createTopLevelClassMapping(this.getDeobfuscatedName(), this.getObfuscatedName());
        this.getFieldMappings().forEach(field -> field.reverse(mapping));
        this.getMethodMappings().forEach(method -> method.reverse(mapping));
        this.getInnerClassMappings().forEach(klass -> klass.reverse(mapping));
        return mapping;
    }

    @Override
    default public TopLevelClassMapping merge(TopLevelClassMapping with, MappingSet parent) {
        return MappingSetMerger.create(this.getMappings(), with.getMappings()).mergeTopLevelClass(this, with, parent);
    }

    @Override
    default public TopLevelClassMapping copy(MappingSet parent) {
        TopLevelClassMapping mapping = parent.createTopLevelClassMapping(this.getObfuscatedName(), this.getDeobfuscatedName());
        this.getFieldMappings().forEach(field -> field.copy(mapping));
        this.getMethodMappings().forEach(method -> method.copy(mapping));
        this.getInnerClassMappings().forEach(klass -> klass.copy(mapping));
        return mapping;
    }
}

