/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.loader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Splitter;
import com.skcraft.launcher.model.minecraft.GameArgument;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.MinecraftArguments;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VersionInfo {
    private String id;
    private MinecraftArguments arguments;
    private String mainClass;
    private List<Library> libraries;
    @JsonIgnore
    private transient boolean overridingArguments;

    public void setMinecraftArguments(String argumentString) {
        MinecraftArguments minecraftArguments = new MinecraftArguments();
        for (String arg : Splitter.on(' ').split(argumentString)) {
            minecraftArguments.getGameArguments().add(new GameArgument(arg));
        }
        this.setArguments(minecraftArguments);
        this.setOverridingArguments(true);
    }

    public String getId() {
        return this.id;
    }

    public MinecraftArguments getArguments() {
        return this.arguments;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public boolean isOverridingArguments() {
        return this.overridingArguments;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setArguments(MinecraftArguments arguments) {
        this.arguments = arguments;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setLibraries(List<Library> libraries) {
        this.libraries = libraries;
    }

    @JsonIgnore
    public void setOverridingArguments(boolean overridingArguments) {
        this.overridingArguments = overridingArguments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        MinecraftArguments this$arguments = this.getArguments();
        MinecraftArguments other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        String this$mainClass = this.getMainClass();
        String other$mainClass = other.getMainClass();
        if (this$mainClass == null ? other$mainClass != null : !this$mainClass.equals(other$mainClass)) {
            return false;
        }
        List<Library> this$libraries = this.getLibraries();
        List<Library> other$libraries = other.getLibraries();
        return !(this$libraries == null ? other$libraries != null : !((Object)this$libraries).equals(other$libraries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        MinecraftArguments $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        String $mainClass = this.getMainClass();
        result = result * 59 + ($mainClass == null ? 43 : $mainClass.hashCode());
        List<Library> $libraries = this.getLibraries();
        result = result * 59 + ($libraries == null ? 43 : ((Object)$libraries).hashCode());
        return result;
    }

    public String toString() {
        return "VersionInfo(id=" + this.getId() + ", arguments=" + this.getArguments() + ", mainClass=" + this.getMainClass() + ", libraries=" + this.getLibraries() + ", overridingArguments=" + this.isOverridingArguments() + ")";
    }
}

