/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.skcraft.launcher.model.modpack.Feature;
import com.skcraft.launcher.swing.CheckboxTable;
import com.skcraft.launcher.swing.FeatureTableModel;
import com.skcraft.launcher.swing.LinedBoxPanel;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.TextFieldPopupMenu;
import com.skcraft.launcher.util.SharedLocale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lombok.NonNull;

public class FeatureSelectionDialog
extends JDialog {
    private final List<Feature> features;
    private final JPanel container = new JPanel(new BorderLayout());
    private final JTextArea descText = new JTextArea(SharedLocale.tr("features.selectForInfo"));
    private final JScrollPane descScroll = new JScrollPane(this.descText);
    private final CheckboxTable componentsTable = new CheckboxTable();
    private final JScrollPane componentsScroll = new JScrollPane(this.componentsTable);
    private final JSplitPane splitPane = new JSplitPane(1, this.componentsScroll, this.descScroll);
    private final LinedBoxPanel buttonsPanel = new LinedBoxPanel(true);
    private final JButton installButton = new JButton(SharedLocale.tr("features.install"));
    private final Object receiver;

    public FeatureSelectionDialog(Window owner, @NonNull List<Feature> features, Object receiver) {
        super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
        if (features == null) {
            throw new NullPointerException("features is marked non-null but is null");
        }
        this.features = features;
        this.receiver = receiver;
        this.setTitle(SharedLocale.tr("features.title"));
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(500, 400));
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
    }

    private void initComponents() {
        this.componentsTable.setModel(new FeatureTableModel(this.features));
        this.descScroll.setVerticalScrollBarPolicy(22);
        this.descText.setFont(new JLabel().getFont());
        this.descText.setEditable(false);
        this.descText.setWrapStyleWord(true);
        this.descText.setLineWrap(true);
        SwingHelper.removeOpaqueness(this.descText);
        this.descText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.splitPane.setDividerLocation(300);
        this.splitPane.setDividerSize(6);
        SwingHelper.flattenJSplitPane(this.splitPane);
        this.container.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.container.add((Component)this.splitPane, "Center");
        this.buttonsPanel.addGlue();
        this.buttonsPanel.addElement(this.installButton);
        JLabel descLabel = new JLabel(SharedLocale.tr("features.intro"));
        descLabel.setBorder(BorderFactory.createEmptyBorder(12, 12, 4, 12));
        SwingHelper.equalWidth(this.installButton, new JButton(SharedLocale.tr("button.cancel")));
        this.add((Component)descLabel, "North");
        this.add((Component)this.container, "Center");
        this.add((Component)this.buttonsPanel, "South");
        this.componentsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FeatureSelectionDialog.this.updateDescription();
            }
        });
        this.installButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = FeatureSelectionDialog.this.receiver;
                synchronized (object) {
                    FeatureSelectionDialog.this.receiver.notifyAll();
                }
                FeatureSelectionDialog.this.dispose();
            }
        });
    }

    private void updateDescription() {
        Feature feature = this.features.get(this.componentsTable.getSelectedRow());
        if (feature != null) {
            this.descText.setText(feature.getDescription());
        } else {
            this.descText.setText(SharedLocale.tr("features.selectForInfo"));
        }
    }
}

