/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.install.Downloader;
import com.skcraft.launcher.util.HttpRequest;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public class HttpDownloader
implements Downloader {
    private static final Logger log = Logger.getLogger(HttpDownloader.class.getName());
    private final Random random = new Random();
    private final HashFunction hf = Hashing.sha1();
    private final File tempDir;
    private int threadCount = 6;
    private int retryDelay = 2000;
    private int tryCount = 3;
    private List<HttpDownloadJob> queue = new ArrayList<HttpDownloadJob>();
    private final Set<String> usedKeys = new HashSet<String>();
    private final List<HttpDownloadJob> running = new ArrayList<HttpDownloadJob>();
    private final List<HttpDownloadJob> failed = new ArrayList<HttpDownloadJob>();
    private long downloaded = 0L;
    private long total = 0L;
    private int left = 0;

    public HttpDownloader(@NonNull File tempDir) {
        if (tempDir == null) {
            throw new NullPointerException("tempDir is marked non-null but is null");
        }
        this.tempDir = tempDir;
    }

    private String createUniqueKey(String baseKey) {
        String key = baseKey;
        int i = 0;
        while (this.usedKeys.contains(key)) {
            key = baseKey + "_" + i++;
        }
        this.usedKeys.add(key);
        return key;
    }

    @Override
    public synchronized File download(@NonNull List<URL> urls, @NonNull String key, long size, String name) {
        if (urls == null) {
            throw new NullPointerException("urls is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("Can't download empty list of URLs");
        }
        String hash = this.hf.hashString(Strings.nullToEmpty(key) + urls.get(0), Charsets.UTF_8).toString();
        File tempFile = new File(this.tempDir, (hash = this.createUniqueKey(hash)).substring(0, 2) + "/" + hash);
        if (!tempFile.exists()) {
            this.total += size;
            ++this.left;
            this.queue.add(new HttpDownloadJob(tempFile, urls, size, name != null ? name : tempFile.getName()));
        }
        return tempFile;
    }

    @Override
    public File download(URL url, String key, long size, String name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(url);
        return this.download(urls, key, size, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws InterruptedException, IOException {
        HttpDownloader httpDownloader = this;
        synchronized (httpDownloader) {
            this.queue = Collections.unmodifiableList(this.queue);
        }
        ListeningExecutorService executor = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(this.threadCount));
        try {
            ArrayList futures = new ArrayList();
            HttpDownloader httpDownloader2 = this;
            synchronized (httpDownloader2) {
                for (HttpDownloadJob job : this.queue) {
                    futures.add(executor.submit(job));
                }
            }
            try {
                Futures.allAsList(futures).get();
            }
            catch (ExecutionException e) {
                throw new IOException("Something went wrong", e);
            }
            httpDownloader2 = this;
            synchronized (httpDownloader2) {
                if (this.failed.size() > 0) {
                    throw new IOException(this.failed.size() + " file(s) could not be downloaded");
                }
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Override
    public synchronized double getProgress() {
        if (this.total <= 0L) {
            return -1.0;
        }
        long downloaded = this.downloaded;
        for (HttpDownloadJob job : this.running) {
            downloaded = (long)((double)downloaded + Math.max(0.0, job.getProgress() * (double)job.size));
        }
        return (double)downloaded / (double)this.total;
    }

    @Override
    public synchronized String getStatus() {
        String failMessage = SharedLocale.tr("downloader.failedCount", this.failed.size());
        if (this.running.size() == 1) {
            return SharedLocale.tr("downloader.downloadingItem", this.running.get(0).getName()) + "\n" + this.running.get(0).getStatus() + "\n" + failMessage;
        }
        if (this.running.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (HttpDownloadJob job : this.running) {
                builder.append("\n");
                builder.append(job.getStatus());
            }
            return SharedLocale.tr("downloader.downloadingList", this.queue.size(), this.left, this.failed.size()) + builder.toString() + "\n" + failMessage;
        }
        return SharedLocale.tr("downloader.noDownloads");
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public class HttpDownloadJob
    implements Runnable,
    ProgressObservable {
        private final File destFile;
        private final List<URL> urls;
        private final long size;
        private String name;
        private HttpRequest request;

        private HttpDownloadJob(File destFile, List<URL> urls, long size, String name) {
            this.destFile = destFile;
            this.urls = urls;
            this.size = size;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpDownloader httpDownloader = HttpDownloader.this;
                synchronized (httpDownloader) {
                    HttpDownloader.this.running.add(this);
                }
                this.download();
                httpDownloader = HttpDownloader.this;
                synchronized (httpDownloader) {
                    HttpDownloader.this.downloaded = HttpDownloader.this.downloaded + this.size;
                }
            }
            catch (IOException e) {
                HttpDownloader httpDownloader = HttpDownloader.this;
                synchronized (httpDownloader) {
                    HttpDownloader.this.failed.add(this);
                }
            }
            catch (InterruptedException e) {
                log.info("Download of " + this.destFile + " was interrupted");
            }
            finally {
                HttpDownloader e = HttpDownloader.this;
                synchronized (e) {
                    HttpDownloader.this.left--;
                    HttpDownloader.this.running.remove(this);
                }
            }
        }

        private void download() throws IOException, InterruptedException {
            log.log(Level.INFO, "Downloading " + this.destFile + " from " + this.urls);
            File destDir = this.destFile.getParentFile();
            File tempFile = new File(destDir, this.destFile.getName() + ".tmp");
            destDir.mkdirs();
            this.download(tempFile);
            this.destFile.delete();
            if (!tempFile.renameTo(this.destFile)) {
                throw new IOException(String.format("Failed to rename %s to %s", tempFile, this.destFile));
            }
        }

        private void download(File file) throws IOException, InterruptedException {
            int trial = 0;
            boolean first = true;
            IOException lastException = null;
            do {
                for (URL url : this.urls) {
                    if (!first) {
                        Thread.sleep((long)((double)(HttpDownloader.this.retryDelay / 2) + HttpDownloader.this.random.nextDouble() * (double)HttpDownloader.this.retryDelay));
                    }
                    first = false;
                    try {
                        this.tryDownloadFrom(url, file, null, 0);
                        return;
                    }
                    catch (IOException e) {
                        lastException = e;
                    }
                }
            } while (++trial < HttpDownloader.this.tryCount);
            throw new IOException("Failed to download from " + this.urls, lastException);
        }

        private void tryDownloadFrom(URL url, File file, HttpRequest.PartialDownloadInfo retryDetails, int tries) throws InterruptedException, IOException {
            block3: {
                try {
                    this.request = HttpRequest.get(url);
                    this.request.setResumeInfo(retryDetails).execute().expectResponseCode(200).saveContent(file);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to download " + url, e);
                    if (tries >= HttpDownloader.this.tryCount || !this.request.isConnected() || !this.request.isSuccessCode()) {
                        throw e;
                    }
                    Optional<HttpRequest.PartialDownloadInfo> byteRangeSupport = this.request.canRetryPartial();
                    if (!byteRangeSupport.isPresent()) break block3;
                    this.tryDownloadFrom(url, file, byteRangeSupport.get(), tries + 1);
                }
            }
        }

        @Override
        public double getProgress() {
            HttpRequest request = this.request;
            return request != null ? request.getProgress() : -1.0;
        }

        @Override
        public String getStatus() {
            double progress = this.getProgress();
            if (progress >= 0.0) {
                return SharedLocale.tr("downloader.jobProgress", this.name, (double)Math.round(progress * 100.0 * 100.0) / 100.0);
            }
            return SharedLocale.tr("downloader.jobPending", this.name);
        }

        public String getName() {
            return this.name;
        }
    }
}

