/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch;

import com.skcraft.launcher.launch.runtime.JavaRuntime;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaProcessBuilder {
    private static final Pattern argsPattern = Pattern.compile("(?:([^\"]\\S*)|\"(.+?)\")\\s*");
    private JavaRuntime runtime;
    private int minMemory;
    private int maxMemory;
    private int permGen;
    private final List<File> classPath = new ArrayList<File>();
    private final List<String> flags = new ArrayList<String>();
    private final List<String> args = new ArrayList<String>();
    private String mainClass;

    private File getJavaBinPath() throws IOException {
        File binDir;
        File path = this.runtime.getDir().getAbsoluteFile();
        if (!path.exists()) {
            throw new IOException("The configured Java runtime path '" + path + "' doesn't exist.");
        }
        if (path.isFile()) {
            path = path.getParentFile();
        }
        if ((binDir = new File(path, "bin")).isDirectory()) {
            path = binDir;
        }
        return path;
    }

    public JavaProcessBuilder classPath(File file) {
        this.getClassPath().add(file);
        return this;
    }

    public JavaProcessBuilder classPath(String path) {
        this.getClassPath().add(new File(path));
        return this;
    }

    public String buildClassPath() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (File file : this.classPath) {
            if (first) {
                first = false;
            } else {
                builder.append(File.pathSeparator);
            }
            builder.append(file.getAbsolutePath());
        }
        return builder.toString();
    }

    public List<String> buildCommand() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        if (this.getRuntime() != null) {
            File javaBinary = new File(this.getJavaBinPath(), "java");
            command.add(javaBinary.getAbsolutePath());
        } else {
            command.add("java");
        }
        command.addAll(this.flags);
        if (this.minMemory > 0) {
            command.add("-Xms" + this.minMemory + "M");
        }
        if (this.maxMemory > 0) {
            command.add("-Xmx" + this.maxMemory + "M");
        }
        if (this.permGen > 0 && (this.getRuntime() == null || this.getRuntime().getMajorVersion() < 8)) {
            command.add("-XX:MaxPermSize=" + this.permGen + "M");
        }
        command.add(this.mainClass);
        command.addAll(this.args);
        return command;
    }

    public static List<String> splitArgs(String str) {
        Matcher matcher = argsPattern.matcher(str);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            parts.add(matcher.group(1));
        }
        return parts;
    }

    public String toString() {
        return "JavaProcessBuilder(runtime=" + this.getRuntime() + ", minMemory=" + this.getMinMemory() + ", maxMemory=" + this.getMaxMemory() + ", permGen=" + this.getPermGen() + ", classPath=" + this.getClassPath() + ", flags=" + this.getFlags() + ", args=" + this.getArgs() + ", mainClass=" + this.getMainClass() + ")";
    }

    public JavaRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(JavaRuntime runtime) {
        this.runtime = runtime;
    }

    public int getMinMemory() {
        return this.minMemory;
    }

    public void setMinMemory(int minMemory) {
        this.minMemory = minMemory;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
    }

    public int getPermGen() {
        return this.permGen;
    }

    public void setPermGen(int permGen) {
        this.permGen = permGen;
    }

    public List<File> getClassPath() {
        return this.classPath;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }
}

