/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.modpack;

import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.install.Installer;
import com.skcraft.launcher.model.minecraft.Side;
import com.skcraft.launcher.model.modpack.Manifest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.NonNull;

public class DownloadableFile {
    private String name;
    private String hash;
    private String location;
    private Side side;
    private int size;

    public LocalFile download(@NonNull Installer installer, Manifest manifest) throws MalformedURLException {
        if (installer == null) {
            throw new NullPointerException("installer is marked non-null but is null");
        }
        URL url = LauncherUtils.concat(manifest.getObjectsUrl(), this.getLocation());
        File local = installer.getDownloader().download(url, this.hash, (long)this.size, this.name);
        return new LocalFile(local, this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getHash() {
        return this.hash;
    }

    public String getLocation() {
        return this.location;
    }

    public Side getSide() {
        return this.side;
    }

    public int getSize() {
        return this.size;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadableFile)) {
            return false;
        }
        DownloadableFile other = (DownloadableFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        Side this$side = this.getSide();
        Side other$side = other.getSide();
        return !(this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadableFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        Side $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        return result;
    }

    public String toString() {
        return "DownloadableFile(name=" + this.getName() + ", hash=" + this.getHash() + ", location=" + this.getLocation() + ", side=" + (Object)((Object)this.getSide()) + ", size=" + this.getSize() + ")";
    }

    public static class LocalFile {
        private final File location;
        private final String name;

        public LocalFile(File location, String name) {
            this.location = location;
            this.name = name;
        }

        public File getLocation() {
            return this.location;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalFile)) {
                return false;
            }
            LocalFile other = (LocalFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$location = this.getLocation();
            File other$location = other.getLocation();
            if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LocalFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "DownloadableFile.LocalFile(location=" + this.getLocation() + ", name=" + this.getName() + ")";
        }
    }
}

