/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.modpack;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.install.Installer;
import com.skcraft.launcher.model.loader.LoaderManifest;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.model.modpack.BaseManifest;
import com.skcraft.launcher.model.modpack.Feature;
import com.skcraft.launcher.model.modpack.LaunchModifier;
import com.skcraft.launcher.model.modpack.ManifestEntry;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Manifest
extends BaseManifest {
    public static final int MIN_PROTOCOL_VERSION = 3;
    private int minimumVersion;
    private URL baseUrl;
    private String librariesLocation;
    private String objectsLocation;
    private String gameVersion;
    @JsonProperty(value="launch")
    private LaunchModifier launchModifier;
    private List<Feature> features = new ArrayList<Feature>();
    @JsonManagedReference(value="manifest")
    private List<ManifestEntry> tasks = new ArrayList<ManifestEntry>();
    @JsonIgnore
    private Installer installer;
    private VersionManifest versionManifest;
    private Map<String, LoaderManifest> loaders = new HashMap<String, LoaderManifest>();

    @JsonIgnore
    public URL getLibrariesUrl() {
        if (Strings.nullToEmpty(this.getLibrariesLocation()) == null) {
            return null;
        }
        try {
            return LauncherUtils.concat(this.baseUrl, Strings.nullToEmpty(this.getLibrariesLocation()) + "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnore
    public URL getObjectsUrl() {
        if (Strings.nullToEmpty(this.getObjectsLocation()) == null) {
            return this.baseUrl;
        }
        try {
            return LauncherUtils.concat(this.baseUrl, Strings.nullToEmpty(this.getObjectsLocation()) + "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateName(String name) {
        if (name != null) {
            this.setName(name);
        }
    }

    public void updateTitle(String title) {
        if (title != null) {
            this.setTitle(title);
        }
    }

    public void updateGameVersion(String gameVersion) {
        if (gameVersion != null) {
            this.setGameVersion(gameVersion);
        }
    }

    public void update(Instance instance) {
        instance.setLaunchModifier(this.getLaunchModifier());
    }

    public int getMinimumVersion() {
        return this.minimumVersion;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public String getLibrariesLocation() {
        return this.librariesLocation;
    }

    public String getObjectsLocation() {
        return this.objectsLocation;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public LaunchModifier getLaunchModifier() {
        return this.launchModifier;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<ManifestEntry> getTasks() {
        return this.tasks;
    }

    public VersionManifest getVersionManifest() {
        return this.versionManifest;
    }

    public Map<String, LoaderManifest> getLoaders() {
        return this.loaders;
    }

    public void setMinimumVersion(int minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setLibrariesLocation(String librariesLocation) {
        this.librariesLocation = librariesLocation;
    }

    public void setObjectsLocation(String objectsLocation) {
        this.objectsLocation = objectsLocation;
    }

    public void setGameVersion(String gameVersion) {
        this.gameVersion = gameVersion;
    }

    @JsonProperty(value="launch")
    public void setLaunchModifier(LaunchModifier launchModifier) {
        this.launchModifier = launchModifier;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public void setTasks(List<ManifestEntry> tasks) {
        this.tasks = tasks;
    }

    public void setVersionManifest(VersionManifest versionManifest) {
        this.versionManifest = versionManifest;
    }

    public void setLoaders(Map<String, LoaderManifest> loaders) {
        this.loaders = loaders;
    }

    @Override
    public String toString() {
        return "Manifest(minimumVersion=" + this.getMinimumVersion() + ", baseUrl=" + this.getBaseUrl() + ", librariesLocation=" + this.getLibrariesLocation() + ", objectsLocation=" + this.getObjectsLocation() + ", gameVersion=" + this.getGameVersion() + ", launchModifier=" + this.getLaunchModifier() + ", features=" + this.getFeatures() + ", tasks=" + this.getTasks() + ", installer=" + this.getInstaller() + ", versionManifest=" + this.getVersionManifest() + ", loaders=" + this.getLoaders() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Manifest)) {
            return false;
        }
        Manifest other = (Manifest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMinimumVersion() != other.getMinimumVersion()) {
            return false;
        }
        URL this$baseUrl = this.getBaseUrl();
        URL other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !((Object)this$baseUrl).equals(other$baseUrl)) {
            return false;
        }
        String this$librariesLocation = this.getLibrariesLocation();
        String other$librariesLocation = other.getLibrariesLocation();
        if (this$librariesLocation == null ? other$librariesLocation != null : !this$librariesLocation.equals(other$librariesLocation)) {
            return false;
        }
        String this$objectsLocation = this.getObjectsLocation();
        String other$objectsLocation = other.getObjectsLocation();
        if (this$objectsLocation == null ? other$objectsLocation != null : !this$objectsLocation.equals(other$objectsLocation)) {
            return false;
        }
        String this$gameVersion = this.getGameVersion();
        String other$gameVersion = other.getGameVersion();
        if (this$gameVersion == null ? other$gameVersion != null : !this$gameVersion.equals(other$gameVersion)) {
            return false;
        }
        LaunchModifier this$launchModifier = this.getLaunchModifier();
        LaunchModifier other$launchModifier = other.getLaunchModifier();
        if (this$launchModifier == null ? other$launchModifier != null : !((Object)this$launchModifier).equals(other$launchModifier)) {
            return false;
        }
        List<Feature> this$features = this.getFeatures();
        List<Feature> other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        List<ManifestEntry> this$tasks = this.getTasks();
        List<ManifestEntry> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        Installer this$installer = this.getInstaller();
        Installer other$installer = other.getInstaller();
        if (this$installer == null ? other$installer != null : !this$installer.equals(other$installer)) {
            return false;
        }
        VersionManifest this$versionManifest = this.getVersionManifest();
        VersionManifest other$versionManifest = other.getVersionManifest();
        if (this$versionManifest == null ? other$versionManifest != null : !((Object)this$versionManifest).equals(other$versionManifest)) {
            return false;
        }
        Map<String, LoaderManifest> this$loaders = this.getLoaders();
        Map<String, LoaderManifest> other$loaders = other.getLoaders();
        return !(this$loaders == null ? other$loaders != null : !((Object)this$loaders).equals(other$loaders));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Manifest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMinimumVersion();
        URL $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : ((Object)$baseUrl).hashCode());
        String $librariesLocation = this.getLibrariesLocation();
        result = result * 59 + ($librariesLocation == null ? 43 : $librariesLocation.hashCode());
        String $objectsLocation = this.getObjectsLocation();
        result = result * 59 + ($objectsLocation == null ? 43 : $objectsLocation.hashCode());
        String $gameVersion = this.getGameVersion();
        result = result * 59 + ($gameVersion == null ? 43 : $gameVersion.hashCode());
        LaunchModifier $launchModifier = this.getLaunchModifier();
        result = result * 59 + ($launchModifier == null ? 43 : ((Object)$launchModifier).hashCode());
        List<Feature> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        List<ManifestEntry> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        Installer $installer = this.getInstaller();
        result = result * 59 + ($installer == null ? 43 : $installer.hashCode());
        VersionManifest $versionManifest = this.getVersionManifest();
        result = result * 59 + ($versionManifest == null ? 43 : ((Object)$versionManifest).hashCode());
        Map<String, LoaderManifest> $loaders = this.getLoaders();
        result = result * 59 + ($loaders == null ? 43 : ((Object)$loaders).hashCode());
        return result;
    }

    public Installer getInstaller() {
        return this.installer;
    }

    @JsonIgnore
    public void setInstaller(Installer installer) {
        this.installer = installer;
    }
}

