/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.concurrency;

import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.skcraft.concurrency.Callback;
import com.skcraft.concurrency.Deferred;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class DeferredImpl<I>
implements Deferred<I> {
    private final ListenableFuture<I> future;
    private final ListeningExecutorService defaultExecutor;

    DeferredImpl(ListenableFuture<I> future, ListeningExecutorService defaultExecutor) {
        this.future = future;
        this.defaultExecutor = defaultExecutor;
    }

    @Override
    public <O> Deferred<O> thenRun(Callable<O> task) {
        return this.thenRunAsync(task, this.defaultExecutor);
    }

    @Override
    public <O> Deferred<O> thenRunAsync(final Callable<O> task, ListeningExecutorService executor) {
        return new DeferredImpl(Futures.transform(this.future, new Function<I, O>(){

            @Override
            public O apply(I input) {
                try {
                    return task.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Executor)executor), this.defaultExecutor);
    }

    @Override
    public Deferred<Void> thenRun(Runnable task) {
        return this.thenRunAsync(task, this.defaultExecutor);
    }

    @Override
    public Deferred<Void> thenRunAsync(final Runnable task, ListeningExecutorService executor) {
        return new DeferredImpl<Void>(Futures.transform(this.future, new Function<I, Void>(){

            @Override
            public Void apply(I input) {
                task.run();
                return null;
            }
        }), this.defaultExecutor);
    }

    @Override
    public Deferred<I> thenTap(Runnable task) {
        return this.thenTapAsync(task, this.defaultExecutor);
    }

    @Override
    public Deferred<I> thenTapAsync(final Runnable task, ListeningExecutorService executor) {
        return this.thenApplyAsync(new Function<I, I>(){

            @Override
            public I apply(I input) {
                task.run();
                return input;
            }
        }, executor);
    }

    @Override
    public <O> Deferred<O> thenApply(Function<I, O> function) {
        return this.thenApplyAsync(function, this.defaultExecutor);
    }

    @Override
    public <O> Deferred<O> thenApplyAsync(Function<I, O> function, ListeningExecutorService executor) {
        return new DeferredImpl<O>(Futures.transform(this.future, function, (Executor)executor), this.defaultExecutor);
    }

    @Override
    public Deferred<I> handle(Callback<I> onSuccess, Callback<Throwable> onFailure) {
        return this.handleAsync(onSuccess, onFailure, this.defaultExecutor);
    }

    @Override
    public Deferred<I> handleAsync(final Callback<I> onSuccess, final Callback<Throwable> onFailure, ListeningExecutorService executor) {
        Futures.addCallback(this.future, new FutureCallback<I>(){

            @Override
            public void onSuccess(I result) {
                onSuccess.handle(result);
            }

            @Override
            public void onFailure(Throwable t) {
                onFailure.handle(t);
            }
        }, executor);
        return this;
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.future.addListener(listener, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public I get() throws InterruptedException, ExecutionException {
        return (I)this.future.get();
    }

    @Override
    public I get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (I)this.future.get(timeout, unit);
    }
}

