/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.concurrency;

import com.skcraft.concurrency.ProgressObservable;

public class ProgressFilter
implements ProgressObservable {
    private final ProgressObservable delegate;
    private final double offset;
    private final double portion;

    public ProgressFilter(ProgressObservable delegate, double offset, double portion) {
        this.delegate = delegate;
        this.offset = offset;
        this.portion = portion;
    }

    @Override
    public double getProgress() {
        return this.offset + this.portion * Math.max(0.0, this.delegate.getProgress());
    }

    @Override
    public String getStatus() {
        return this.delegate.getStatus();
    }

    public static ProgressObservable between(ProgressObservable delegate, double from, double to) {
        return new ProgressFilter(delegate, from, to - from);
    }
}

