/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.loader.profiles;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.skcraft.launcher.model.loader.InstallProcessor;
import com.skcraft.launcher.model.loader.ProcessorEntry;
import com.skcraft.launcher.model.loader.SidedData;
import com.skcraft.launcher.model.minecraft.Library;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ModernForgeInstallProfile {
    private int spec;
    private List<Library> libraries;
    private List<InstallProcessor> processors;
    private Map<String, SidedData<String>> data;
    private String minecraft;

    public List<ProcessorEntry> toProcessorEntries(final String loaderName) {
        return Lists.transform(this.getProcessors(), new Function<InstallProcessor, ProcessorEntry>(){

            @Override
            public ProcessorEntry apply(InstallProcessor input) {
                return new ProcessorEntry(loaderName, input);
            }
        });
    }

    public int getSpec() {
        return this.spec;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public List<InstallProcessor> getProcessors() {
        return this.processors;
    }

    public Map<String, SidedData<String>> getData() {
        return this.data;
    }

    public String getMinecraft() {
        return this.minecraft;
    }

    public void setSpec(int spec) {
        this.spec = spec;
    }

    public void setLibraries(List<Library> libraries) {
        this.libraries = libraries;
    }

    public void setProcessors(List<InstallProcessor> processors) {
        this.processors = processors;
    }

    public void setData(Map<String, SidedData<String>> data) {
        this.data = data;
    }

    public void setMinecraft(String minecraft) {
        this.minecraft = minecraft;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModernForgeInstallProfile)) {
            return false;
        }
        ModernForgeInstallProfile other = (ModernForgeInstallProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSpec() != other.getSpec()) {
            return false;
        }
        List<Library> this$libraries = this.getLibraries();
        List<Library> other$libraries = other.getLibraries();
        if (this$libraries == null ? other$libraries != null : !((Object)this$libraries).equals(other$libraries)) {
            return false;
        }
        List<InstallProcessor> this$processors = this.getProcessors();
        List<InstallProcessor> other$processors = other.getProcessors();
        if (this$processors == null ? other$processors != null : !((Object)this$processors).equals(other$processors)) {
            return false;
        }
        Map<String, SidedData<String>> this$data = this.getData();
        Map<String, SidedData<String>> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$minecraft = this.getMinecraft();
        String other$minecraft = other.getMinecraft();
        return !(this$minecraft == null ? other$minecraft != null : !this$minecraft.equals(other$minecraft));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModernForgeInstallProfile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSpec();
        List<Library> $libraries = this.getLibraries();
        result = result * 59 + ($libraries == null ? 43 : ((Object)$libraries).hashCode());
        List<InstallProcessor> $processors = this.getProcessors();
        result = result * 59 + ($processors == null ? 43 : ((Object)$processors).hashCode());
        Map<String, SidedData<String>> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $minecraft = this.getMinecraft();
        result = result * 59 + ($minecraft == null ? 43 : $minecraft.hashCode());
        return result;
    }

    public String toString() {
        return "ModernForgeInstallProfile(spec=" + this.getSpec() + ", libraries=" + this.getLibraries() + ", processors=" + this.getProcessors() + ", data=" + this.getData() + ", minecraft=" + this.getMinecraft() + ")";
    }
}

