/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.update;

import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import lombok.NonNull;

public class HardResetter
implements Callable<Instance>,
ProgressObservable {
    private final Instance instance;
    private File currentDir;

    public HardResetter(@NonNull Instance instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        this.instance = instance;
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return SharedLocale.tr("instanceResetter.resetting", this.instance.getTitle());
    }

    @Override
    public Instance call() throws Exception {
        this.instance.setInstalled(false);
        this.instance.setUpdatePending(true);
        Persistence.commitAndForget(this.instance);
        new File(this.instance.getDir(), "update_cache.json").delete();
        this.removeDir(new File(this.instance.getContentDir(), "config"));
        this.removeDir(new File(this.instance.getContentDir(), "mods"));
        return this.instance;
    }

    private void removeDir(File dir) throws IOException, InterruptedException {
        try {
            if (dir.isDirectory()) {
                this.currentDir = dir;
                LauncherUtils.interruptibleDelete(dir, new ArrayList<File>());
            }
        }
        finally {
            this.currentDir = null;
        }
    }

    public String toString() {
        File dir = this.currentDir;
        if (dir != null) {
            return "Removing " + dir.getAbsolutePath();
        }
        return "Working...";
    }
}

