/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.loader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.skcraft.launcher.model.loader.LoaderSubResolver;
import com.skcraft.launcher.model.minecraft.Side;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstallProcessor {
    private String jar;
    private List<String> classpath;
    private List<String> args;
    private Map<String, String> outputs;
    private List<String> sides;

    public List<String> resolveArgs(LoaderSubResolver resolver) {
        return Lists.transform(this.getArgs(), resolver);
    }

    public Map<String, String> resolveOutputs(LoaderSubResolver resolver) {
        if (this.getOutputs() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOutputs().entrySet()) {
            result.put(resolver.apply(entry.getKey()), resolver.apply(entry.getValue()));
        }
        return result;
    }

    public boolean shouldRunOn(Side side) {
        if (this.sides == null) {
            return true;
        }
        switch (side) {
            case CLIENT: {
                return this.sides.contains("client");
            }
            case SERVER: {
                return this.sides.contains("server");
            }
        }
        return false;
    }

    public String getJar() {
        return this.jar;
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public Map<String, String> getOutputs() {
        return this.outputs;
    }

    public List<String> getSides() {
        return this.sides;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public void setClasspath(List<String> classpath) {
        this.classpath = classpath;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public void setOutputs(Map<String, String> outputs) {
        this.outputs = outputs;
    }

    public void setSides(List<String> sides) {
        this.sides = sides;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstallProcessor)) {
            return false;
        }
        InstallProcessor other = (InstallProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jar = this.getJar();
        String other$jar = other.getJar();
        if (this$jar == null ? other$jar != null : !this$jar.equals(other$jar)) {
            return false;
        }
        List<String> this$classpath = this.getClasspath();
        List<String> other$classpath = other.getClasspath();
        if (this$classpath == null ? other$classpath != null : !((Object)this$classpath).equals(other$classpath)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        Map<String, String> this$outputs = this.getOutputs();
        Map<String, String> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        List<String> this$sides = this.getSides();
        List<String> other$sides = other.getSides();
        return !(this$sides == null ? other$sides != null : !((Object)this$sides).equals(other$sides));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstallProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jar = this.getJar();
        result = result * 59 + ($jar == null ? 43 : $jar.hashCode());
        List<String> $classpath = this.getClasspath();
        result = result * 59 + ($classpath == null ? 43 : ((Object)$classpath).hashCode());
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        Map<String, String> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        List<String> $sides = this.getSides();
        result = result * 59 + ($sides == null ? 43 : ((Object)$sides).hashCode());
        return result;
    }

    public String toString() {
        return "InstallProcessor(jar=" + this.getJar() + ", classpath=" + this.getClasspath() + ", args=" + this.getArgs() + ", outputs=" + this.getOutputs() + ", sides=" + this.getSides() + ")";
    }
}

