/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.update;

import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import lombok.NonNull;

public class Remover
implements Callable<Instance>,
ProgressObservable {
    private final Instance instance;

    public Remover(@NonNull Instance instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        this.instance = instance;
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return SharedLocale.tr("instanceDeleter.deleting", this.instance.getDir());
    }

    @Override
    public Instance call() throws Exception {
        this.instance.setInstalled(false);
        this.instance.setUpdatePending(true);
        Persistence.commitAndForget(this.instance);
        LauncherUtils.checkInterrupted();
        Thread.sleep(2000L);
        ArrayList<File> failures = new ArrayList<File>();
        try {
            LauncherUtils.interruptibleDelete(this.instance.getDir(), failures);
        }
        catch (IOException e) {
            Thread.sleep(1000L);
            LauncherUtils.interruptibleDelete(this.instance.getDir(), failures);
        }
        if (failures.size() > 0) {
            throw new LauncherException(failures.size() + " failed to delete", SharedLocale.tr("instanceDeleter.failures", failures.size()));
        }
        return this.instance;
    }
}

