/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.modpack;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.google.common.base.Strings;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="name")
public class Feature
implements Comparable<Feature> {
    private String name;
    private String description;
    private Recommendation recommendation;
    private boolean selected;

    public Feature() {
    }

    public Feature(String name, String description, boolean selected) {
        this.name = name;
        this.description = description;
        this.selected = selected;
    }

    public Feature(Feature feature) {
        this.setName(feature.getName());
        this.setDescription(feature.getDescription());
        this.setSelected(feature.isSelected());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int compareTo(Feature o) {
        return Strings.nullToEmpty(this.getName()).compareTo(Strings.nullToEmpty(o.getName()));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Recommendation getRecommendation() {
        return this.recommendation;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRecommendation(Recommendation recommendation) {
        this.recommendation = recommendation;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return "Feature(name=" + this.getName() + ", description=" + this.getDescription() + ", recommendation=" + (Object)((Object)this.getRecommendation()) + ", selected=" + this.isSelected() + ")";
    }

    public static enum Recommendation {
        STARRED,
        AVOID;


        @JsonCreator
        public static Recommendation fromJson(String text) {
            return Recommendation.valueOf(text.toUpperCase());
        }

        @JsonValue
        public String toJson() {
            return this.name().toLowerCase();
        }
    }
}

