/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.skcraft.launcher.Configuration;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.dialog.AboutDialog;
import com.skcraft.launcher.dialog.ConsoleFrame;
import com.skcraft.launcher.dialog.component.BetterComboBox;
import com.skcraft.launcher.launch.runtime.AddJavaRuntime;
import com.skcraft.launcher.launch.runtime.JavaRuntime;
import com.skcraft.launcher.launch.runtime.JavaRuntimeFinder;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.ActionListeners;
import com.skcraft.launcher.swing.FormPanel;
import com.skcraft.launcher.swing.LinedBoxPanel;
import com.skcraft.launcher.swing.ObjectSwingMapper;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SharedLocale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.filechooser.FileFilter;
import lombok.NonNull;

public class ConfigurationDialog
extends JDialog {
    private final Configuration config;
    private final ObjectSwingMapper mapper;
    private final JPanel tabContainer = new JPanel(new BorderLayout());
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final FormPanel javaSettingsPanel = new FormPanel();
    private final JComboBox<JavaRuntime> jvmRuntime = new BetterComboBox<JavaRuntime>();
    private final JTextField jvmArgsText = new JTextField();
    private final JSpinner minMemorySpinner = new JSpinner();
    private final JSpinner maxMemorySpinner = new JSpinner();
    private final JSpinner permGenSpinner = new JSpinner();
    private final FormPanel gameSettingsPanel = new FormPanel();
    private final JSpinner widthSpinner = new JSpinner();
    private final JSpinner heightSpinner = new JSpinner();
    private final FormPanel proxySettingsPanel = new FormPanel();
    private final JCheckBox useProxyCheck = new JCheckBox(SharedLocale.tr("options.useProxyCheck"));
    private final JTextField proxyHostText = new JTextField();
    private final JSpinner proxyPortText = new JSpinner();
    private final JTextField proxyUsernameText = new JTextField();
    private final JPasswordField proxyPasswordText = new JPasswordField();
    private final FormPanel advancedPanel = new FormPanel();
    private final JTextField gameKeyText = new JTextField();
    private final LinedBoxPanel buttonsPanel = new LinedBoxPanel(true);
    private final JButton okButton = new JButton(SharedLocale.tr("button.ok"));
    private final JButton cancelButton = new JButton(SharedLocale.tr("button.cancel"));
    private final JButton aboutButton = new JButton(SharedLocale.tr("options.about"));
    private final JButton logButton = new JButton(SharedLocale.tr("options.launcherConsole"));

    public ConfigurationDialog(Window owner, @NonNull Launcher launcher) {
        super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        this.config = launcher.getConfig();
        this.mapper = new ObjectSwingMapper(this.config);
        JavaRuntime[] javaRuntimes = JavaRuntimeFinder.getAvailableRuntimes().toArray(new JavaRuntime[0]);
        DefaultComboBoxModel<JavaRuntime> model = new DefaultComboBoxModel<JavaRuntime>(javaRuntimes);
        boolean configRuntimeFound = Arrays.stream(javaRuntimes).anyMatch(r -> r.equals(this.config.getJavaRuntime()));
        if (!configRuntimeFound && this.config.getJavaRuntime() != null) {
            model.insertElementAt(this.config.getJavaRuntime(), 0);
        }
        this.jvmRuntime.setModel(model);
        this.jvmRuntime.addItem(AddJavaRuntime.ADD_RUNTIME_SENTINEL);
        this.jvmRuntime.setSelectedItem(this.config.getJavaRuntime());
        this.setTitle(SharedLocale.tr("options.title"));
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(400, 500));
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.mapper.map(this.jvmArgsText, "jvmArgs");
        this.mapper.map(this.minMemorySpinner, "minMemory");
        this.mapper.map(this.maxMemorySpinner, "maxMemory");
        this.mapper.map(this.permGenSpinner, "permGen");
        this.mapper.map(this.widthSpinner, "windowWidth");
        this.mapper.map(this.heightSpinner, "windowHeight");
        this.mapper.map(this.useProxyCheck, "proxyEnabled");
        this.mapper.map(this.proxyHostText, "proxyHost");
        this.mapper.map(this.proxyPortText, "proxyPort");
        this.mapper.map(this.proxyUsernameText, "proxyUsername");
        this.mapper.map(this.proxyPasswordText, "proxyPassword");
        this.mapper.map(this.gameKeyText, "gameKey");
        this.mapper.copyFromObject();
    }

    private void initComponents() {
        this.javaSettingsPanel.addRow(new JLabel(SharedLocale.tr("options.jvmPath")), this.jvmRuntime);
        this.javaSettingsPanel.addRow(new JLabel(SharedLocale.tr("options.jvmArguments")), this.jvmArgsText);
        this.javaSettingsPanel.addRow(Box.createVerticalStrut(15));
        this.javaSettingsPanel.addRow(new JLabel(SharedLocale.tr("options.64BitJavaWarning")));
        this.javaSettingsPanel.addRow(new JLabel(SharedLocale.tr("options.minMemory")), this.minMemorySpinner);
        this.javaSettingsPanel.addRow(new JLabel(SharedLocale.tr("options.maxMemory")), this.maxMemorySpinner);
        this.javaSettingsPanel.addRow(new JLabel(SharedLocale.tr("options.permGen")), this.permGenSpinner);
        SwingHelper.removeOpaqueness(this.javaSettingsPanel);
        this.tabbedPane.addTab(SharedLocale.tr("options.javaTab"), SwingHelper.alignTabbedPane(this.javaSettingsPanel));
        this.gameSettingsPanel.addRow(new JLabel(SharedLocale.tr("options.windowWidth")), this.widthSpinner);
        this.gameSettingsPanel.addRow(new JLabel(SharedLocale.tr("options.windowHeight")), this.heightSpinner);
        SwingHelper.removeOpaqueness(this.gameSettingsPanel);
        this.tabbedPane.addTab(SharedLocale.tr("options.minecraftTab"), SwingHelper.alignTabbedPane(this.gameSettingsPanel));
        this.proxySettingsPanel.addRow(this.useProxyCheck);
        this.proxySettingsPanel.addRow(new JLabel(SharedLocale.tr("options.proxyHost")), this.proxyHostText);
        this.proxySettingsPanel.addRow(new JLabel(SharedLocale.tr("options.proxyPort")), this.proxyPortText);
        this.proxySettingsPanel.addRow(new JLabel(SharedLocale.tr("options.proxyUsername")), this.proxyUsernameText);
        this.proxySettingsPanel.addRow(new JLabel(SharedLocale.tr("options.proxyPassword")), this.proxyPasswordText);
        SwingHelper.removeOpaqueness(this.proxySettingsPanel);
        this.tabbedPane.addTab(SharedLocale.tr("options.proxyTab"), SwingHelper.alignTabbedPane(this.proxySettingsPanel));
        this.advancedPanel.addRow(new JLabel(SharedLocale.tr("options.gameKey")), this.gameKeyText);
        SwingHelper.removeOpaqueness(this.advancedPanel);
        this.tabbedPane.addTab(SharedLocale.tr("options.advancedTab"), SwingHelper.alignTabbedPane(this.advancedPanel));
        this.buttonsPanel.addElement(this.logButton);
        this.buttonsPanel.addElement(this.aboutButton);
        this.buttonsPanel.addGlue();
        this.buttonsPanel.addElement(this.okButton);
        this.buttonsPanel.addElement(this.cancelButton);
        this.tabContainer.add((Component)this.tabbedPane, "Center");
        this.tabContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.tabContainer, "Center");
        this.add((Component)this.buttonsPanel, "South");
        SwingHelper.equalWidth(this.okButton, this.cancelButton);
        this.cancelButton.addActionListener(ActionListeners.dispose(this));
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.showAboutDialog(ConfigurationDialog.this);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationDialog.this.save();
            }
        });
        this.logButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleFrame.showMessages();
            }
        });
        this.jvmRuntime.addActionListener(e -> {
            if (this.jvmRuntime.getSelectedItem() == AddJavaRuntime.ADD_RUNTIME_SENTINEL) {
                this.jvmRuntime.setSelectedItem(null);
                this.jvmRuntime.setPopupVisible(false);
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setFileFilter(new JavaRuntimeFileFilter());
                chooser.setDialogTitle("Choose a Java executable");
                int result = chooser.showOpenDialog(this);
                if (result == 0) {
                    JavaRuntime runtime = JavaRuntimeFinder.getRuntimeFromPath(chooser.getSelectedFile().getAbsolutePath());
                    MutableComboBoxModel model = (MutableComboBoxModel)this.jvmRuntime.getModel();
                    model.insertElementAt(runtime, 0);
                    this.jvmRuntime.setSelectedItem(runtime);
                }
            }
        });
    }

    public void save() {
        this.mapper.copyFromSwing();
        this.config.setJavaRuntime((JavaRuntime)this.jvmRuntime.getSelectedItem());
        Persistence.commitAndForget(this.config);
        this.dispose();
    }

    static class JavaRuntimeFileFilter
    extends FileFilter {
        JavaRuntimeFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().startsWith("java") && f.canExecute();
        }

        @Override
        public String getDescription() {
            return "Java runtime executables";
        }
    }
}

