/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.google.common.collect.Lists;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.install.InstallTask;
import com.skcraft.launcher.model.loader.InstallProcessor;
import com.skcraft.launcher.model.loader.LoaderManifest;
import com.skcraft.launcher.model.loader.LoaderSubResolver;
import com.skcraft.launcher.model.loader.SidedData;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.Side;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.model.modpack.DownloadableFile;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.util.Environment;
import com.skcraft.launcher.util.FileUtils;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class ProcessorTask
implements InstallTask {
    private static final Logger log = Logger.getLogger(ProcessorTask.class.getName());
    private final InstallProcessor processor;
    private final LoaderManifest loaderManifest;
    private final Manifest manifest;
    private final HashMap<String, DownloadableFile.LocalFile> localFiles;
    private transient String message = "";
    private transient double progress = 0.0;

    @Override
    public void execute(Launcher launcher) throws Exception {
        ClassLoader parent;
        VersionManifest versionManifest = this.manifest.getVersionManifest();
        LoaderSubResolver resolver = new LoaderSubResolver(this.manifest, this.loaderManifest, Environment.getInstance(), Side.CLIENT, launcher.getLibrariesDir(), this.localFiles);
        Map<String, SidedData<String>> sidedData = this.loaderManifest.getSidedData();
        sidedData.put("ROOT", SidedData.of(launcher.getInstallerDir().getAbsolutePath()));
        sidedData.put("MINECRAFT_JAR", SidedData.of(launcher.getJarPath(versionManifest).getAbsolutePath()));
        sidedData.put("LIBRARY_DIR", SidedData.of(launcher.getLibrariesDir().getAbsolutePath()));
        sidedData.put("MINECRAFT_VERSION", SidedData.of(versionManifest.getId()));
        this.message = "Resolving parameters";
        List<String> programArgs = this.processor.resolveArgs(resolver);
        Map<String, String> outputs = this.processor.resolveOutputs(resolver);
        this.message = "Finding libraries";
        Library execFile = this.loaderManifest.findLibrary(this.processor.getJar());
        File jar = launcher.getLibraryFile(execFile);
        JarFile jarFile = new JarFile(jar);
        String mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        jarFile.close();
        if (mainClass == null || mainClass.isEmpty()) {
            throw new RuntimeException(String.format("Processor jar file '%s' has no main class!", this.processor.getJar()));
        }
        ArrayList<URL> classpath = Lists.newArrayList(jar.toURI().toURL());
        int i = 0;
        int total = this.processor.getClasspath().size();
        for (String libraryName : this.processor.getClasspath()) {
            this.message = "Adding library " + libraryName;
            File libraryFile = launcher.getLibraryFile(this.loaderManifest.findLibrary(libraryName));
            if (!libraryFile.exists()) {
                throw new RuntimeException(String.format("Missing library '%s' for processor '%s'", libraryName, this.processor.getJar()));
            }
            classpath.add(libraryFile.toURI().toURL());
            this.progress = (double)(++i) / (double)total;
        }
        this.progress = 0.0;
        this.message = "Executing";
        log.info(String.format("Running processor '%s' with %d args", this.processor.getJar(), programArgs.size()));
        log.info("Arguments: [" + String.join((CharSequence)", ", programArgs) + "]");
        try {
            parent = (ClassLoader)ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable ignored) {
            parent = null;
        }
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        URLClassLoader cl = new URLClassLoader(classpath.toArray(new URL[0]), parent);
        try {
            Class<?> mainClazz = Class.forName(mainClass, true, cl);
            Method main = mainClazz.getDeclaredMethod("main", String[].class);
            Thread.currentThread().setContextClassLoader(cl);
            main.invoke(null, new Object[]{programArgs.toArray(new String[0])});
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prev);
        }
        this.message = "Verifying";
        this.progress = 1.0;
        if (!outputs.isEmpty()) {
            this.progress = 0.0;
            i = 0;
            total = outputs.size();
            for (Map.Entry<String, String> output : outputs.entrySet()) {
                File artifact = new File(output.getKey());
                if (!artifact.exists()) {
                    throw new RuntimeException(String.format("Artifact '%s' missing", output.getKey()));
                }
                if (!FileUtils.getShaHash(artifact).equals(output.getValue())) {
                    log.warning("Invalid hash, expected " + output.getValue());
                    throw new RuntimeException(String.format("Artifact '%s' has invalid hash!", output.getKey()));
                }
                this.progress = (double)(++i) / (double)total;
            }
        }
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public String getStatus() {
        return SharedLocale.tr("installer.runningProcessor", this.processor.getJar(), this.message);
    }

    public ProcessorTask(InstallProcessor processor, LoaderManifest loaderManifest, Manifest manifest, HashMap<String, DownloadableFile.LocalFile> localFiles) {
        this.processor = processor;
        this.loaderManifest = loaderManifest;
        this.manifest = manifest;
        this.localFiles = localFiles;
    }
}

